local function sub_v(a, b)
  return {a[1] - b[1], a[2] - b[2]}
end
local function add_v(a, b)
  return {a[1] + b[1], a[2] + b[2]}
end
local burner_collision = {{-2.5, -2.5}, {2.5, 2.5}}
local water_position = {0, burner_collision[1][2]+0.1}
local water_collision = {{-0.1, water_position[2]-0.1}, {0.1, water_position[2]+0.1}}
local water_output = {0, -0.9}
local generator_position = {0, 0}
local generator_collision = {{-1.6, -1.6}, {1.6, 1.6}}
local generator_input = {0.5, 1.7}
local burner_water_input = water_position
local burner_steam_output = add_v(water_position,{0,0.1})
--{-0.5, 1.7}
-- works
local water_collision_shifted = {sub_v(water_collision[1], water_position), sub_v(water_collision[2], water_position)}
local water_output_shifted = sub_v(water_output, water_position)
log("test: ("..water_output_shifted[1]..","..water_output_shifted[2]..")")

local generator_collision_shifted = {sub_v(generator_collision[1], generator_position), sub_v(generator_collision[2], generator_position)}
local generator_input_shifted = sub_v(generator_input, generator_position)
local fluidbox_size = 0.125

local blank = {
  filename = "__omnimatter_crystal__/graphics/blank.png",
  priority = "high",
  width = 1,
  height = 1,
  frame_count = 1
}
local crystal_reactor = {
  type = "boiler",
  name = "crystal-reactor",
  icon = "__omnimatter_crystal__/graphics/icons/crystal-reactor.png",
  flags = {"placeable-neutral", "player-creation"},
  minable = {hardness = 0.2, mining_time = 0.5, result = "crystal-reactor"},
  max_health = 250,
  corpse = "small-remnants",
  vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
  mode = "output-to-separate-pipe",
  resistances =
  {
    { type = "fire", percent = 100 },
    { type = "explosion", percent = 30 },
    { type = "impact", percent = 50 }
  },
  selection_box = {{-2.5,-2.5}, {2.5,2.5}},
  collision_box = burner_collision,
  target_temperature = 165,
  fluid_input = { name = "water", amount = 0.0 },
  fluid_output = { name = "steam", amount = 10.0 },
  fluid_box =
  {
    base_area = fluidbox_size,
    height = 2,
    base_level = -1,
    production_type = "input-output",
    pipe_connections = { {type = "input", position = burner_water_input} },
  },
  output_fluid_box =
  {
    base_area = fluidbox_size,
    height = 2,
    production_type = "output",
    pipe_connections = { { type = "output", position = burner_steam_output} },
  },
  energy_consumption = "20kW",
  energy_source =
  {
    type = "burner",
    fuel_category = "crystal",
    effectivity = 1,
    fuel_inventory_size = 4,
    emissions = 0.1 / 3,
    smoke =
    {
      {
        name = "smoke",
        north_position = util.by_pixel(20, -85),
        south_position = util.by_pixel(20, -85),
        east_position = util.by_pixel(20, -85),
        west_position = util.by_pixel(20, -85),
        frequency = 30,
        starting_vertical_speed = 0.0,
        starting_frame_deviation = 60,
        deviation = {-1, 1},
      }
    }
  },
  working_sound =
  {
    sound =
    {
      filename = "__base__/sound/furnace.ogg",
      volume = 1.6
    },
    max_sounds_per_type = 3
  },
  fire_flicker_enabled = true,
  fire_glow_flicker_enabled = false,
  burning_cooldown = 20
}

local layers = {
  layers =
  {
    {
      filename = "__omnimatter_crystal__/graphics/buildings/crystal-reactor.png",
      priority = "extra-high",
      line_length = 4,
      frame_count = 16,
      animation_speed = 0.5,
      width = 1280/4,
      height = 1280/4,
      shift = {2,-2},
    },
  }
}
crystal_reactor.structure = {}
crystal_reactor.structure.north = layers
crystal_reactor.structure.south = layers
crystal_reactor.structure.east = layers
crystal_reactor.structure.west = layers
local fire = {
      filename = "__omnimatter_crystal__/graphics/buildings/crystal-reactor.png",
      priority = "extra-high",
      line_length = 4,
      frame_count = 16,
      animation_speed = 0.25,
      width = 1280/4,
      height = 1280/4,
  shift = util.by_pixel(0, -10),
  blend_mode = "additive",
}
crystal_reactor.fire = {}
crystal_reactor.fire.north = blank
crystal_reactor.fire.south = blank
crystal_reactor.fire.east = blank
crystal_reactor.fire.west = blank

local fire_glow = {
      filename = "__omnimatter_crystal__/graphics/buildings/crystal-reactor.png",
      priority = "extra-high",
      line_length = 4,
      frame_count = 16,
      animation_speed = 0.5,
      width = 1280/4,
      height = 1280/4,
  shift = util.by_pixel(0, -10),
}
crystal_reactor.fire_glow = {}
crystal_reactor.fire_glow.north = fire_glow
crystal_reactor.fire_glow.south = fire_glow
crystal_reactor.fire_glow.east = fire_glow
crystal_reactor.fire_glow.west = fire_glow

data:extend({crystal_reactor})


local crystal_reactor_water = {
  type = "offshore-pump",
  name = "crystal-reactor-water",
  icon = "__omnimatter_crystal__/graphics/icons/crystal-reactor.png",
  flags = {"placeable-neutral", "player-creation", "filter-directions", "placeable-off-grid", "not-blueprintable", "not-deconstructable"},
  max_health = 10000,
  healing_per_tick = 10000,
  corpse = "small-remnants",
  fluid = "water",
  order="z",
  selectable_in_game = false,
  selection_box = {{0, 0}, {0, 0}},
  collision_box = water_collision_shifted,
  collision_mask = {"not-colliding-with-itself"},
  fluid_box =
  {
    base_area = fluidbox_size,
    base_level = 1,
    pipe_connections = {{ type = "output", position = water_output_shifted}}
  },
  pumping_speed = 20,
  tile_width = 1,
  vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
  picture = { north = blank, east = blank, south = blank, west = blank },
}
data:extend({crystal_reactor_water})

local crystal_reactor_generator = {
  type = "generator",
  name = "crystal-reactor-generator",
  icon = "__omnimatter_crystal__/graphics/icons/crystal-reactor.png",
  flags = {"placeable-neutral","player-creation", "placeable-off-grid", "not-blueprintable", "not-deconstructable"},
  max_health = 10000,
  healing_per_tick = 10000,
  corpse = "big-remnants",
  dying_explosion = "medium-explosion",
  effectivity = 1.01, -- negate the round down to 1.9MW displayed
  order="z",
  fluid_usage_per_tick = 10,
  maximum_temperature = 165,
  selectable_in_game = false,
  selection_box = {{-2,-2}, {2,2}},
  collision_box = generator_collision_shifted,
  collision_mask = {"not-colliding-with-itself"},
  fluid_box =
  {
    base_area = fluidbox_size,
    height = 2,
    base_level = -1,
    production_type = "input-output",
    pipe_connections = {{ type = "input", position = generator_input_shifted}}
  },
  fluid_input = { name = "steam", amount = 10.0, minimum_temperature = 100.0 },
  energy_source = { type = "electric", usage_priority = "secondary-output"},
  horizontal_animation = { layers = { blank }, },
  vertical_animation = { layers = { blank }, },
  vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
  min_perceived_performance = 0.25,
  performance_to_sound_speedup = 0.5,
  working_sound =
  {
    sound =
    {
      filename = "__base__/sound/boiler.ogg",
      volume = 0.8
    },
    max_sounds_per_type = 3
  },
}
data:extend({crystal_reactor_generator})


local pipe =
{
  type = "storage-tank",
  name = "crystal-reactor-pipe",
  order="z",
  icon = "__omnimatter_crystal__/graphics/icons/crystal-reactor.png",
  flags = {"placeable-player", "player-creation", "placeable-off-grid"},
  max_health = 10000,
  healing_per_tick = 10000,
  selectable_in_game = false,
  collision_box = {{-0.9, -0.4}, {0.9, 0.4}},
  selection_box = {{0, 0}, {0, 0}},
  fluid_box = {
    base_area = fluidbox_size,
    pipe_connections = {
      { position = {-0.5, -1} },
      { position = {0.5, -1} },
    },
  },
  window_bounding_box = {{0, 0}, {0, 0}},
  pictures = {
    picture = { sheet =blank, },
    fluid_background =blank,
    window_background =blank,
    flow_sprite =blank,
    gas_flow = blank,
  },
  flow_length_in_ticks = 360,
  circuit_wire_max_distance = 0
}
data:extend({pipe})
